/******************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtKnx module.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
****************************************************************************/

#ifndef QKNXCHAR_H
#define QKNXCHAR_H

#include <QtKnx/qknxdatapointtype.h>
#include <QtKnx/qtknxglobal.h>

QT_BEGIN_NAMESPACE

class Q_KNX_EXPORT QKnxChar : public QKnxFixedSizeDatapointType
{
public:
    QKnxChar();
    explicit QKnxChar(unsigned char value);

    static const constexpr int TypeSize = 0x01;
    static const constexpr int MainType = 0x04;

    unsigned char value() const;
    bool setValue(unsigned char value);

    bool isValid() const override;

protected:
    QKnxChar(int subType, unsigned char value);
};

class Q_KNX_EXPORT QKnxCharASCII : public QKnxChar
{
public:
    QKnxCharASCII();
    explicit QKnxCharASCII(char value);

    static const constexpr int SubType = 0x01;

    char character() const;
    bool setCharacter(char value);
};

class Q_KNX_EXPORT QKnxChar88591 : public QKnxChar
{
public:
    QKnxChar88591();
    explicit QKnxChar88591(unsigned char character);

    static const constexpr int SubType = 0x02;

    unsigned char character() const;
    bool setCharacter(unsigned char value);
};

QT_END_NAMESPACE

#endif
